/* tabs-state.js */
/**
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

/**
 * JavaScript behavior to allow selected tab to be remained after save or page reload
 * keeping state in localstorage
 */

jQuery(function() {

    var loadTab = function() {
        var $ = jQuery.noConflict();

        jQuery(document).find('a[data-toggle="tab"]').on('click', function(e) {
            // Store the selected tab href in localstorage
            window.localStorage.setItem('tab-href', $(e.target).attr('href'));
        });

        var activateTab = function(href) {
            var $el = $('a[data-toggle="tab"]a[href*=' + href + ']');
            $el.tab('show');
        };

        var hasTab = function(href){
            return $('a[data-toggle="tab"]a[href*=' + href + ']').length;
        };

        if (localStorage.getItem('tab-href')) {
            // When moving from tab area to a different view
            if(!hasTab(localStorage.getItem('tab-href'))){
                localStorage.removeItem('tab-href');
                return true;
            }
            // Clean default tabs
            $('a[data-toggle="tab"]').parent().removeClass('active');
            var tabhref = localStorage.getItem('tab-href');
            // Add active attribute for selected tab indicated by url
            activateTab(tabhref);
            // Check whether internal tab is selected (in format <tabname>-<id>)
            var seperatorIndex = tabhref.indexOf('-');
            if (seperatorIndex !== -1) {
                var singular = tabhref.substring(0, seperatorIndex);
                var plural = singular + "s";
                activateTab(plural);
            }
        }
    };
    setTimeout(loadTab, 100);

});
;

/* caption.js */
/*
        GNU General Public License version 2 or later; see LICENSE.txt
*/
var JCaption=function(c){var e,b,a=function(f){e=jQuery.noConflict();b=f;e(b).each(function(g,h){d(h)})},d=function(i){var h=e(i),f=h.attr("title"),j=h.attr("width")||i.width,l=h.attr("align")||h.css("float")||i.style.styleFloat||"none",g=e("<p/>",{text:f,"class":b.replace(".","_")}),k=e("<div/>",{"class":b.replace(".","_")+" "+l,css:{"float":l,width:j}});h.parent().before(k,h);k.append(h);if(f!==""){k.append(g)}};a(c)};;

/* js_fed70830811c672174876a5001de222b.core.js */
function switchFontSize(ckname,val){var bd=document.getElementsByTagName('body');if(!bd||!bd.length)return;bd=bd[0];switch(val){case'inc':if(CurrentFontSize+1<7){CurrentFontSize++;}
break;case'dec':if(CurrentFontSize-1>0){CurrentFontSize--;}
break;case'reset':default:CurrentFontSize=DefaultFontSize;}
var newclass='fs'+CurrentFontSize;bd.className=bd.className.replace(new RegExp('fs.?','g'),'');bd.className=trim(bd.className);bd.className+=(bd.className?' ':'')+newclass;createCookie(ckname,CurrentFontSize,365);}
function switchTool(ckname,val){createCookie(ckname,val,365);window.location.reload();}
function cpanel_reset(){var matches=document.cookie.match(new RegExp('(?:^|;)\\s*'+tmpl_name.escapeRegExp()+'_([^=]*)=([^;]*)','g'));if(!matches)return;for(var i=0;i<matches.length;i++){var ck=matches[i].match(new RegExp('(?:^|;)\\s*'+tmpl_name.escapeRegExp()+'_([^=]*)=([^;]*)'));if(ck){createCookie(tmpl_name+'_'+ck[1],'',-1);}}
if(window.location.href.indexOf('?')>-1){window.location.href=window.location.href.substr(0,window.location.href.indexOf('?'));}else{window.location.reload(true);}}
function cpanel_apply(){var elems=document.getElementById('ja-cpanel-main').getElementsByTagName('*');var usersetting={};for(var i=0;i<elems.length;i++){var el=elems[i];if(el.name&&(match=el.name.match(/^user_(.*)$/))){var name=match[1];var value='';if(el.tagName.toLowerCase()=='input'&&(el.type.toLowerCase()=='radio'||el.type.toLowerCase()=='checkbox')){if(el.checked)value=el.value;}else{value=el.value;}
if(usersetting[name]){if(value)usersetting[name]=value+','+usersetting[name];}else{usersetting[name]=value;}}}
for(var k in usersetting){name=tmpl_name+'_'+k;value=usersetting[k].trim();if(value.length>0){createCookie(name,value,365);}}
if(window.location.href.indexOf('?')>-1){window.location.href=window.location.href.substr(0,window.location.href.indexOf('?'));}else{window.location.reload(true);}}
function createCookie(name,value,days){if(days){var date=new Date();date.setTime(date.getTime()+(days*24*60*60*1000));var expires="; expires="+date.toGMTString();}else{expires="";}
document.cookie=name+"="+value+expires+"; path=/";}
function trim(str,chars){return ltrim(rtrim(str,chars),chars);}
function ltrim(str,chars){chars=chars||"\\s";return str.replace(new RegExp("^["+chars+"]+","g"),"");}
function rtrim(str,chars){chars=chars||"\\s";return str.replace(new RegExp("["+chars+"]+$","g"),"");}
function getScreenWidth(){var x=0;if(self.innerHeight){x=self.innerWidth;}else if(document.documentElement&&document.documentElement.clientHeight){x=document.documentElement.clientWidth;}else if(document.body){x=document.body.clientWidth;}
return x;}
function equalHeight(els){els=$$_(els);if(!els||els.length<2)return;var maxh=0;var els_=[];els.each(function(el,i){if(!el)return;els_[i]=el;var ch=els_[i].getCoordinates().height;maxh=(maxh<ch)?ch:maxh;},this);els_.each(function(el,i){if(!el)return;if(el.getStyle('padding-top')!=null&&el.getStyle('padding-bottom')!=null){if(maxh-el.getStyle('padding-top').toInt()-el.getStyle('padding-bottom').toInt()>0){el.setStyle('min-height',maxh-el.getStyle('padding-top').toInt()-el.getStyle('padding-bottom').toInt());}}else{if(maxh>0)el.setStyle('min-height',maxh);}},this);}
function getDeepestWrapper(el){while(el.getChildren().length==1){el=el.getChildren()[0];}
return el;}
function fixHeight(els,group1,group2){els=$$_(els);group1=$$_(group1);group2=$$_(group2);if(!els||!group1)return;var height=0;group1.each(function(el){if(!el)return;height+=el.getCoordinates().height;});if(group2){group2.each(function(el){if(!el)return;height-=el.getCoordinates().height;});}
els.each(function(el,i){if(!el)return;if(el.getStyle('padding-top')!=null&&el.getStyle('padding-bottom')!=null){if(height-el.getStyle('padding-top').toInt()-el.getStyle('padding-bottom').toInt()>0){el.setStyle('min-height',height-el.getStyle('padding-top').toInt()-el.getStyle('padding-bottom').toInt());}}else{if(height>0){el.setStyle('min-height',height);}}});}
function addFirstLastItem(el){el=$(el);if(!el||!el.getChildren()||!el.getChildren().length)return;el.getChildren()[0].addClass('first-item');el.getChildren()[el.getChildren().length-1].addClass('last-item');}
function $$_(els){if(typeOf(els)=='string')return $$(els);var els_=[];els.each(function(el){el=$(el);if(el)els_.push(el);});return els_;}
$(document).addEvent('domready',function(){$$('[data-dismiss="alert"]').each(function(el){el.addEvent('click',function(){el.getParent().destroy();if($('system-message').getChildren().length==0){Joomla.removeMessages();}});});});;;

/* js_1ca829dbc22776acf7a9b827d62942f2.mega.js */
var JRMenu=window.JRMenu||{};var jaMegaMenuMoo=new Class({Implements:Options,options:{slide:0,duration:300,fading:0,bgopacity:0.9,delayHide:500,direction:'down',action:'mouseenter',hidestyle:'normal',offset:-5,fixArrow:false},toElement:function(){return this.menu;},initialize:function(menu,options){this.menu=$(menu);if(!this.menu){return;}
this.setOptions(options);if(!this.options.slide&&!this.options.fading){this.options.delayHide=10;}
JRMenu.inst=this;this.menu.addClass('mm-enable');this.childopen=[];this.imgloaded=false;this.loaded=false;this.addnavbtn();this.prepare();},addnavbtn:function(){if(!(Browser.ie&&Browser.version<9)){var jlevel0=this.menu.getElement('ul.level0');if(jlevel0){var jmega=this.menu,jbutton=new Element('div',{id:'ja-menu-button',html:'Navigation',styles:{display:'none'}}).inject(jmega,'before');jbutton.addEvent('click',function(e){e.stop();if(jmega.getStyle('display')=='block'){jmega.removeClass('active').setStyle('display','none');jbutton.removeClass('active');}else{jmega.addClass('active').setStyle('display','block');jbutton.addClass('active');}});$(document).addEvent('click',function(){if(!jmega.hasClass('mm-enable')){jmega.removeClass('active').setStyle('display','none');}
jbutton.removeClass('active');});}
JRMenu.mmenuid=null;window.addEvent('resize',function(){clearTimeout(JRMenu.mmenuid);JRMenu.mmenuid=setTimeout(function(){JRMenu.inst.start();},100);});}},prepare:function(){var imgElms=this.menu.getElements('img');if(imgElms.length&&!this.imgloaded){var imgSrcs=[];imgElms.each(function(image){imgSrcs.push(image.src)});new Asset.images(imgSrcs,{onComplete:function(){this.imgloaded=true;this.start();}.bind(this)});setTimeout(function(){this.imgloaded=true;this.start();}.bind(this),3000);}else{window.addEvent('load',function(){this.imgloaded=true;this.start();}.bind(this));}},detect:function(){var jbutton=$('ja-menu-button'),rs=true;if(jbutton){rs=jbutton.getComputedStyle('display')=='none';if(rs!=this.menu.hasClass('mm-enable')){this.menu[rs?'addClass':'removeClass']('mm-enable');this.menu.setStyle('display',rs?'block':'none');}}
return rs;},start:function(){if(!this.detect()||!this.imgloaded||this.loaded){return;}
this.loaded=true;this.zindex=1000;var pw=this.menu;while(pw=pw.getParent()){if(pw.hasClass('main')||pw.hasClass('wrap')){this.wrapper=pw;break;}}
this.items=this.menu.getElements('li.mega');this.items.each(function(li){var link=li.getChildren('a.mega')[0],child=li.getChildren('.childcontent')[0],level0=li.getParent().hasClass('level0'),parent=this.getParent(li),item={stimer:null,direction:((level0&&this.options.direction=='up')?0:1)};if(child){var childwrap=child.getElement('.childcontent-inner-wrap'),childinner=child.getElement('.childcontent-inner'),width=childinner.getWidth(),height=childinner.getHeight(),padding=childwrap.getStyle('padding-left').toInt()+childwrap.getStyle('padding-right').toInt(),overflow=false;child.setStyles({width:width+20,height:height+20});childwrap.setStyle('width',width);if(['auto','scroll'].contains(childinner.getStyle('overflow'))){overflow=true;if(Browser.ie){if(Browser.version<=7){childinner.setStyle('position','relative');}
if(Browser.version==6){childinner.setStyle('height',childinner.getStyle('max-height')||400);}}}
if(this.options.direction=='up'){if(level0){child.setStyle('top',-child.getHeight());}else{child.setStyle('bottom',0);}}}
if(child&&this.options.bgopacity){new Element('div',{'class':'childcontent-bg',styles:{width:'100%',height:height,opacity:this.options.bgopacity,position:'absolute',top:0,left:0,zIndex:1,background:child.getStyle('background'),backgroundImage:child.getStyle('background-image'),backgroundRepeat:child.getStyle('background-repeat'),backgroundColor:child.getStyle('background-color')}}).inject(childwrap,'top');child.setStyle('background','none');childwrap.setStyles({position:'relative',zIndex:2});}
if(child&&(this.options.slide||this.options.fading)){if(child.hasClass('right')){child.setStyle('right',0);}
var fx=new Fx.Morph(childwrap,{duration:this.options.duration,transition:Fx.Transitions.linear,onComplete:this.itemAnimDone.bind(this,item),link:'cancel'}),stylesOn={};if(this.options.slide){if(level0){stylesOn[item.direction==1?'margin-top':'bottom']=0;}else{stylesOn[window.isRTL?'margin-right':'margin-left']=0;}}
if(this.options.fading){stylesOn['opacity']=1;}}
if(child&&this.options.action=='click'){li.addEvent('click',function(e){e.stopPropagation();if(li.hasClass('group')){return;}
if(item.status=='open'){if(this.cursorIn(li,e)){this.itemHide(item);}else{this.hideOthers(li);}}else{this.itemShow(item);}}.bind(this));}
if(this.options.action=='mouseover'||this.options.action=='mouseenter'){li.addEvent('mouseover',function(e){if(li.hasClass('group')){return;}
e.stop();clearTimeout(item.stimer);clearTimeout(this.atimer);this.intent(item,'open');this.itemShow(item);}.bind(this)).addEvent('mouseleave',function(e){if(li.hasClass('group')){return;}
clearTimeout(item.stimer);this.intent(item,'close');if(child){item.stimer=this.itemHide.delay(this.options.delayHide,this,[item]);}else{this.itemHide(item);}}.bind(this));if(link&&child){link.addEvent('click',function(e){if(!item.clickable){e.stop();}});}
li.addEvent('click',function(e){e.stopPropagation()});if(child){child.addEvent('mouseover',function(){clearTimeout(item.stimer);clearTimeout(this.atimer);this.intent(item,'open');this.itemShow(item);}.bind(this)).addEvent('mouseleave',function(e){e.stop();this.intent(item,'close');clearTimeout(item.stimer);if(!this.cursorIn(item.el,e)){this.atimer=this.hideAlls.delay(this.options.delayHide,this);}}.bind(this))}}
if(link&&!child){link.addEvent('click',function(e){e.stopPropagation();this.hideOthers(null);this.menu.getElements('.active').removeClass('active');var p=li;while(p){var idata=p.retrieve('item');p.addClass('active');idata.link.addClass('active');p=idata.parent;}}.bind(this));}
Object.append(item,{el:li,parent:parent,link:link,child:child,childwrap:childwrap,childinner:childinner,width:width,height:height,padding:padding,level0:level0,fx:fx,stylesOn:stylesOn,overflow:overflow,clickable:!(link&&child)});li.store('item',item);},this);var container=$('ja-wrapper');if(!container){container=document.body;}
container.addEvent('click',function(e){this.hideAlls();}.bind(this));this.menu.getElements('.childcontent').setStyle('display','none');},getParent:function(el){var p=el;while((p=p.getParent())){if(this.items.contains(p)&&!p.hasClass('group')){return p;}
if(!p||p==this.menu){return null;}}},intent:function(item,action){item.intent=action;while(item.parent&&(item=item.parent.retrieve('item'))){item.intent=action;}},cursorIn:function(el,event){if(!el||!event){return false;}
var pos=el.getPosition(),cursor=event.page;return(cursor.x>pos.x&&cursor.x<pos.x+el.getWidth()&&cursor.y>pos.y&&cursor.y<pos.y+el.getHeight());},itemOver:function(item){item.el.addClass('over');if(item.el.hasClass('haschild')){item.el.removeClass('haschild').addClass('haschild-over');}
if(item.link){item.link.addClass('over');}},itemOut:function(item){item.el.removeClass('over');if(item.el.hasClass('haschild-over')){item.el.removeClass('haschild-over').addClass('haschild');}
if(item.link){item.link.removeClass('over');}},itemShow:function(item){if(!this.menu.hasClass('mm-enable')){return;}
if(this.childopen.indexOf(item)<this.childopen.length-1){this.hideOthers(item.el);}
if(item.status=='open'){return;}
this.itemOver(item);if(item.level0){this.childopen.length=0;}
if(item.child){this.childopen.push(item);}
item.intent='open';item.status='open';this.enableclick.delay(100,this,item);if(item.child){this.positionSubmenu(item);if(item.fx&&!item.stylesOff){item.stylesOff={};if(this.options.slide){if(item.level0){item.stylesOff[item.direction==1?'margin-top':'bottom']=-item.height;}else{item.stylesOff[window.isRTL?'margin-right':'margin-left']=(item.direction==1?-item.width:item.width);}}
if(this.options.fading){item.stylesOff['opacity']=0;}
item.fx.set(item.stylesOff);}
item.child.setStyles({display:'block',zIndex:this.zindex++});}
if(!item.fx||!item.child){return;}
item.child.setStyle('overflow','hidden');if(item.overflow){item.childinner.setStyle('overflow','hidden');}
item.fx.start(item.stylesOn);},itemHide:function(item){if(!this.menu.hasClass('mm-enable')){return;}
clearTimeout(item.stimer);item.status='close';item.intent='close';this.itemOut(item);this.childopen.erase(item);if(!item.fx&&item.child){item.child.setStyle('display','none');}
if(!item.fx||!item.child||item.child.getStyle('opacity')=='0'){return;}
item.child.setStyle('overflow','hidden');if(item.overflow){item.childinner.setStyle('overflow','hidden');}
switch(this.options.hidestyle){case'fast':item.fx.options.duration=100;item.fx.start(item.stylesOff);break;case'fastwhenshow':item.fx.start(Object.merge(item.stylesOff,{'opacity':0}));break;case'normal':default:item.fx.start(item.stylesOff);break;}},itemAnimDone:function(item){if(item.status=='close'){if(this.options.hidestyle.test(/fast/)){item.fx.options.duration=this.options.duration;if(!this.options.fading){item.childwrap.setStyle('opacity',1);}}
item.child.setStyle('display','none');this.disableclick.delay(100,this,item);var pitem=item.parent?item.parent.retrieve('item'):null;if(pitem&&pitem.intent=='close'){this.itemHide(pitem);}}
if(item.status=='open'){item.child.setStyle('overflow','');if(item.overflow){item.childinner.setStyle('overflow-y','auto');}
item.childwrap.setStyle('opacity',1);item.child.setStyle('display','block');}},hideOthers:function(el){this.childopen.each(function(item){if(!el||(item.el!=el&&!item.el.contains(el))){item.intent='close';}});var last=this.childopen.getLast();if(last&&last.intent=='close'){this.itemHide(last);}},hideAlls:function(el){this.childopen.flatten().each(function(item){if(!item.fx){this.itemHide(item);}else{item.intent='close';}},this);if(this.options.slide||this.options.fading){var last=this.childopen.getLast();if(last&&last.intent=='close'){this.itemHide(last);}}},enableclick:function(item){if(item.link&&item.child){item.clickable=true;}},disableclick:function(item){item.clickable=false;},positionSubmenu:function(item){var options=this.options,offsleft,offstop,left,top,stylesOff={},icoord=item.el.getCoordinates(),bodySize=$(document.body).getScrollSize(),winRect={top:window.getScrollTop(),left:window.getScrollLeft(),width:window.getWidth(),height:window.getHeight()},wrapRect=this.wrapper?this.wrapper.getCoordinates():{top:0,left:0,width:winRect.width,height:winRect.height};winRect.top=Math.max(winRect.top,wrapRect.top);winRect.left=Math.max(winRect.left,wrapRect.left);winRect.width=Math.min(winRect.width,wrapRect.width);winRect.height=Math.min(winRect.height,$(document.body).getScrollHeight());winRect.right=winRect.left+winRect.width;winRect.bottom=winRect.top+winRect.height;if(!item.level0){var pitem=item.parent.retrieve('item'),offsety=parseFloat(pitem.child.getFirst().getStyle('margin-top')),offsetx=parseFloat(pitem.child.getFirst().getStyle(window.isRTL?'margin-right':'margin-left'));item.direction=pitem.direction;window.isRTL&&(offsetx=0-offsetx);icoord.top-=offsety;icoord.bottom-=offsety;icoord.left-=offsetx;icoord.right-=offsetx;}
if(item.level0){if(window.isRTL){offsleft=Math.max(winRect.left,icoord.right-item.width-20);left=Math.max(0,offsleft-winRect.left);}else{offsleft=Math.max(winRect.left,Math.min(winRect.right-item.width,icoord.left));left=Math.max(0,Math.min(winRect.right-item.width,icoord.left)-winRect.left);}}else{if(window.isRTL){if(item.direction==1){offsleft=icoord.left-item.width-20+options.offset;left=-icoord.width-20;if(offsleft<winRect.left){item.direction=0;offsleft=Math.min(winRect.right,Math.max(winRect.left,icoord.right+item.padding-20-options.offset));left=icoord.width-20;stylesOff['margin-right']=item.width;}}else{offsleft=icoord.right+item.padding-20;left=icoord.width-20;if(offsleft+item.width>winRect.right){item.direction=1;offsleft=Math.max(winRect.left,icoord.left-item.width-20);left=-icoord.width-20;stylesOff['margin-right']=-item.width;}}}else{if(item.direction==1){offsleft=icoord.right-options.offset;left=icoord.width;if(offsleft+item.width>winRect.right){item.direction=0;offsleft=Math.max(winRect.left,icoord.left-item.width-item.padding+options.offset);left=-icoord.width;stylesOff['margin-left']=item.width;}}else{offsleft=icoord.left-item.width-item.padding+options.offset;left=-icoord.width;if(offsleft<winRect.left){item.direction=1;offsleft=Math.max(winRect.left,Math.min(winRect.right-item.width,icoord.right-options.offset));left=icoord.width;stylesOff['margin-left']=-item.width;}}}}
if(options.slide&&item.fx&&Object.getLength(stylesOff)){item.fx.set(stylesOff);}
if(options.fixArrow&&item.childinner){item.childinner.setStyle('background-position',(icoord.left-offsleft+(icoord.width/2-4.5))+'px top');}
var oldp=item.child.getStyle('display');item.child.setStyle('display','block');if(item.child.getOffsetParent()){left=offsleft-item.child.getOffsetParent().getCoordinates().left;}
item.child.setStyles({'margin-left':0,'left':left,'display':oldp});}});;;

/* js_cfe9293d1cb9b2336355def1d453a923.acymailing_module.js */
function submitacymailingform(task,formName){var varform=document[formName];var filterEmail=/^([a-z0-9_'&\.\-\+=])+\@(([a-z0-9\-])+\.)+([a-z0-9]{2,10})+$/i;if(!varform.elements){if(varform[0].elements['user[email]']&&varform[0].elements['user[email]'].value&&filterEmail.test(varform[0].elements['user[email]'].value)){varform=varform[0];}else{varform=varform[varform.length-1];}}
if(task!='optout'){nameField=varform.elements['user[name]'];if(nameField&&((typeof acymailing!='undefined'&&nameField.value==acymailing['NAMECAPTION'])||nameField.value.replace(/ /g,"").length<2)){if(typeof acymailing!='undefined'){alert(acymailing['NAME_MISSING']);}
nameField.className=nameField.className+' invalid';return false;}}
var emailField=varform.elements['user[email]'];if(emailField){if(typeof acymailing=='undefined'||emailField.value!=acymailing['EMAILCAPTION'])emailField.value=emailField.value.replace(/ /g,"");if(!emailField||(typeof acymailing!='undefined'&&emailField.value==acymailing['EMAILCAPTION'])||!filterEmail.test(emailField.value)){if(typeof acymailing!='undefined'){alert(acymailing['VALID_EMAIL']);}
emailField.className=emailField.className+' invalid';return false;}}
if(varform.elements['hiddenlists'].value.length<1){var listschecked=false;var alllists=varform.elements['subscription[]'];if(alllists&&(typeof alllists.value=='undefined'||alllists.value.length==0)){for(b=0;b<alllists.length;b++){if(alllists[b].checked)listschecked=true;}
if(!listschecked){alert(acymailing['NO_LIST_SELECTED']);return false;}}}
if(task!='optout'&&typeof acymailing!='undefined'&&typeof acymailing['reqFields'+formName]!='undefined'&&acymailing['reqFields'+formName].length>0){for(var i=0;i<acymailing['reqFields'+formName].length;i++){elementName='user['+acymailing['reqFields'+formName][i]+']';elementToCheck=varform.elements[elementName];if(elementToCheck){var isValid=false;if(typeof elementToCheck.value!='undefined'){if(elementToCheck.value==' '&&typeof varform[elementName+'[]']!='undefined'){if(varform[elementName+'[]'].checked){isValid=true;}else{for(var a=0;a<varform[elementName+'[]'].length;a++){if((varform[elementName+'[]'][a].checked||varform[elementName+'[]'][a].selected)&&varform[elementName+'[]'][a].value.length>0)isValid=true;}}}else{if(elementToCheck.value.replace(/ /g,"").length>0){if(typeof acymailing['excludeValues'+formName]=='undefined'||typeof acymailing['excludeValues'+formName][acymailing['reqFields'+formName][i]]=='undefined'||acymailing['excludeValues'+formName][acymailing['reqFields'+formName][i]]!=elementToCheck.value)isValid=true;}}}else{for(var a=0;a<elementToCheck.length;a++){if(elementToCheck[a].checked&&elementToCheck[a].value.length>0)isValid=true;}}
if(!isValid){elementToCheck.className=elementToCheck.className+' invalid';alert(acymailing['validFields'+formName][i]);return false;}}else{if((varform.elements[elementName+'[day]']&&varform.elements[elementName+'[day]'].value<1)||(varform.elements[elementName+'[month]']&&varform.elements[elementName+'[month]'].value<1)||(varform.elements[elementName+'[year]']&&varform.elements[elementName+'[year]'].value<1902)){if(varform.elements[elementName+'[day]']&&varform.elements[elementName+'[day]'].value<1)varform.elements[elementName+'[day]'].className=varform.elements[elementName+'[day]'].className+' invalid';if(varform.elements[elementName+'[month]']&&varform.elements[elementName+'[month]'].value<1)varform.elements[elementName+'[month]'].className=varform.elements[elementName+'[month]'].className+' invalid';if(varform.elements[elementName+'[year]']&&varform.elements[elementName+'[year]'].value<1902)varform.elements[elementName+'[year]'].className=varform.elements[elementName+'[year]'].className+' invalid';alert(acymailing['validFields'+formName][i]);return false;}
if((varform.elements[elementName+'[country]']&&varform.elements[elementName+'[country]'].value<1)||(varform.elements[elementName+'[num]']&&varform.elements[elementName+'[num]'].value<3)){if(varform.elements[elementName+'[country]']&&varform.elements[elementName+'[country]'].value<1)varform.elements[elementName+'[country]'].className=varform.elements[elementName+'[country]'].className+' invalid';if(varform.elements[elementName+'[num]']&&varform.elements[elementName+'[num]'].value<3)varform.elements[elementName+'[num]'].className=varform.elements[elementName+'[num]'].className+' invalid';alert(acymailing['validFields'+formName][i]);return false;}}}}
if(task!='optout'&&typeof acymailing!='undefined'&&typeof acymailing['checkFields'+formName]!='undefined'&&acymailing['checkFields'+formName].length>0){for(var i=0;i<acymailing['checkFields'+formName].length;i++){elementName='user['+acymailing['checkFields'+formName][i]+']';elementtypeToCheck=acymailing['checkFieldsType'+formName][i];elementToCheck=varform.elements[elementName].value;switch(elementtypeToCheck){case'number':myregexp=new RegExp('^[0-9]*$');break;case'letter':myregexp=new RegExp('^[A-Za-z\u00C0-\u017F ]*$');break;case'letnum':myregexp=new RegExp('^[0-9a-zA-Z\u00C0-\u017F ]*$');break;case'regexp':myregexp=new RegExp(acymailing['checkFieldsRegexp'+formName][i]);break;}
if(!myregexp.test(elementToCheck)){alert(acymailing['validCheckFields'+formName][i]);return false;}}}
var captchaField=varform.elements['acycaptcha'];if(captchaField){if(captchaField.value.length<1){if(typeof acymailing!='undefined'){alert(acymailing['CAPTCHA_MISSING']);}
captchaField.className=captchaField.className+' invalid';return false;}}
if(task!='optout'){var termsandconditions=varform.terms;if(termsandconditions&&!termsandconditions.checked){if(typeof acymailing!='undefined'){alert(acymailing['ACCEPT_TERMS']);}
termsandconditions.className=termsandconditions.className+' invalid';return false;}}
taskField=varform.task;taskField.value=task;if(!varform.elements['ajax']||!varform.elements['ajax'].value||varform.elements['ajax'].value=='0'){varform.submit();return false;}
if(window.jQuery){var form=jQuery('#'+formName);data=form.serialize();jQuery.ajax({url:document.getElementById(formName).action,data:data,type:'POST',async:false,complete:function(){form.addClass('acymailing_module_loading');form.css("filter:","alpha(opacity=50)");form.css("-moz-opacity","0.5");form.css("-khtml-opacity","0.5");form.css("opacity","0.5");},success:function(response){response=JSON.parse(response);acymailingDisplayAjaxResponseJQuery(unescape(response.message),response.type,formName);},error:function(){acymailingDisplayAjaxResponseJQuery('Ajax Request Failure','error',formName);}});}else{try{var form=document.id(formName);}catch(err){var form=$(formName);}
data=form.toQueryString();if(typeof Ajax=='function'){new Ajax(form.action,{data:data,method:'post',onRequest:function()
{form.addClass('acymailing_module_loading');form.setStyle("filter:","alpha(opacity=50)");form.setStyle("-moz-opacity","0.5");form.setStyle("-khtml-opacity","0.5");form.setStyle("opacity","0.5");},onSuccess:function(response)
{response=Json.evaluate(response);acymailingDisplayAjaxResponseMootools(unescape(response.message),response.type,formName);},onFailure:function(){acymailingDisplayAjaxResponseMootools('Ajax Request Failure','error',formName);}}).request();}else{new Request.JSON({url:document.id(formName).action,data:data,method:'post',onRequest:function()
{form.addClass('acymailing_module_loading');form.setStyle("filter:","alpha(opacity=50)");form.setStyle("-moz-opacity","0.5");form.setStyle("-khtml-opacity","0.5");form.setStyle("opacity","0.5");},onSuccess:function(response)
{acymailingDisplayAjaxResponseMootools(unescape(response.message),response.type,formName);},onFailure:function(){acymailingDisplayAjaxResponseMootools('Ajax Request Failure','error',formName);}}).send();}}
return false;}
function acymailingDisplayAjaxResponseJQuery(message,type,formName){var toggleButton=jQuery('#acymailing_togglemodule_'+formName);if(toggleButton&&toggleButton.hasClass('acyactive')){var wrapper=toggleButton.parent().parent().children()[1];jQuery(wrapper).css('height','');};var responseContainer=jQuery('#acymailing_fulldiv_'+formName+' .responseContainer')[0];if(typeof responseContainer=='undefined'){responseContainer=document.createElement('div');var fulldiv=jQuery('#acymailing_fulldiv_'+formName);fulldiv.prepend(responseContainer);oldContainerHeight='0px';}else{oldContainerHeight=jQuery(responseContainer).css('height');}
responseContainer.className='responseContainer';var form=jQuery('#'+formName);form.removeClass('acymailing_module_loading');responseContainer.innerHTML=message;if(type=='success'){jQuery(responseContainer).addClass('acymailing_module_success');}else{jQuery(responseContainer).addClass('acymailing_module_error');form.css("filter:","alpha(opacity=100)");form.css("-moz-opacity","1");form.css("-khtml-opacity","1");form.css("opacity","1");}
newContainerHeight=jQuery(responseContainer).css('height');if(type=='success'){form.animate({'height':0,'opacity':0});}
jQuery(responseContainer).css({'height':oldContainerHeight,'filter:':"alpha(opacity=0)",'-moz-opacity':0,'-khtml-opacity':0,'opacity':0});jQuery(responseContainer).animate({'height':newContainerHeight,'opacity':1});}
function acymailingDisplayAjaxResponseMootools(message,type,formName)
{try{var toggleButton=document.id('acymailing_togglemodule_'+formName);}catch(err){var toggleButton=$('acymailing_togglemodule_'+formName);}
if(toggleButton&&toggleButton.hasClass('acyactive')){var wrapper=toggleButton.getParent().getParent().getChildren()[1];wrapper.setStyle('height','');};try{var responseContainer=document.getElements('#acymailing_fulldiv_'+formName+' .responseContainer')[0];}catch(err){var responseContainer=$$('#acymailing_fulldiv_'+formName+' .responseContainer')[0];}
if(typeof responseContainer=='undefined'){responseContainer=new Element('div');try{var fulldiv=document.id('acymailing_fulldiv_'+formName);}catch(err){var fulldiv=$('acymailing_fulldiv_'+formName);}
responseContainer.inject(fulldiv,'top');oldContainerHeight='0px';}else{oldContainerHeight=responseContainer.getStyle('height');}
responseContainer.className='responseContainer';try{var form=document.id(formName);}catch(err){var form=$(formName);}
form.removeClass('acymailing_module_loading');responseContainer.innerHTML=message;if(type=='success'){responseContainer.addClass('acymailing_module_success');}else{responseContainer.addClass('acymailing_module_error');form.setStyle("filter:","alpha(opacity=100)");form.setStyle("-moz-opacity","1");form.setStyle("-khtml-opacity","1");form.setStyle("opacity","1");}
newContainerHeight=responseContainer.getStyle('height');if(typeof Ajax=='function')
{if(type=='success'){var myEffect=new Fx.Styles(form,{duration:500,transition:Fx.Transitions.linear});myEffect.start({'height':[form.getSize().size.y,0],'opacity':[1,0]});}
try{responseContainer.setStyle('height',oldContainerHeight+'px');responseContainer.setStyle("filter:","alpha(opacity=0)");responseContainer.setStyle("-moz-opacity","0");responseContainer.setStyle("-khtml-opacity","0");responseContainer.setStyle("opacity","0");}
catch(e){}
var myEffect2=new Fx.Styles(responseContainer,{duration:500,transition:Fx.Transitions.linear});myEffect2.start({'height':[oldContainerHeight,newContainerHeight],'opacity':[0,1]});}
else
{if(type=='success'){form.set('morph');form.morph({'height':'0px','opacity':0});form.setStyles({'display':'none'});}
if(newContainerHeight!='auto'){responseContainer.setStyles({'height':oldContainerHeight,'opacity':0});responseContainer.set('morph');responseContainer.morph({'height':newContainerHeight,'opacity':1});}}}
function refreshCaptchaModule(formName){var captchaLink=document.getElementById('captcha_picture_'+formName).src;myregexp=new RegExp('val[-=]([0-9]+)');valToChange=captchaLink.match(myregexp)[1];document.getElementById('captcha_picture_'+formName).src=captchaLink.replace(valToChange,valToChange+'0');};;

/* js_9bf5dee3239e4e64f4bb263b08d28259.ja_contentslider.js */
var JS_ContentSlider=new Class({initialize:function(options)
{this.options=Object.append({w:100,h:200,num_elem:4,total:0,url:'',mode:'horizontal',direction:'right',wrapper:'ja-slide-wrapper',duration:1000,interval:3000,auto:1},options||{});if(this.options.total){if(this.options.total<this.options.num_elem)this.options.num_elem=this.options.total;this.elements=new Array(this.options.total);}else
this.elements=new Array();this.current=0;this.options.wrapper.setStyle('position','relative');this.options.wrapper.setStyle('overflow','hidden');if(this.options.mode=='vertical'){this.options.wrapper.setStyle('width',this.options.w);this.options.wrapper.setStyle('height',this.options.h*this.options.num_elem);}else{this.options.wrapper.setStyle('width',this.options.w*this.options.num_elem);this.options.wrapper.setStyle('height',this.options.h);}
elems=this.options.wrapper.getElements('.content_element');for(i=0;i<elems.length;i++){elems[i].setStyle('width',this.options.w);elems[i].setStyle('height',this.options.h);elems[i].setStyle('display','none');}
this.ef_u={};this.ef_d={};this.ef_l={};this.ef_r={};for(i=0;i<=this.options.num_elem;i++){this.ef_u[i]={'top':[i*this.options.h,(i-1)*this.options.h]};this.ef_d[i]={'top':[(i-1)*this.options.h,i*this.options.h]};this.ef_l[i]={'left':[i*this.options.w,(i-1)*this.options.w]};this.ef_r[i]={'left':[(i-1)*this.options.w,i*this.options.w]};}},getFx:function(){if(this.options.mode=='vertical'){if(this.options.direction=='left'||this.options.direction=='up'){return this.ef_u;}else{return this.ef_d;}}else{if(this.options.direction=='left'||this.options.direction=='up'){return this.ef_l;}else{return this.ef_r;}}},add:function(text){var divobj=new Element('DIV',{'id':'jsslide_'+this.elements.length,'class':'jsslide'});divobj.innerHTML=text;divobj.setStyle('position','absolute');divobj.setStyle('width',this.options.w);divobj.setStyle('height',this.options.h);if(this.elements.length>1){divobj.injectAfter(this.elements[this.elements.length-2]);}else{divobj.inject(this.options.wrapper);}
this.hide(divobj);this.elements.push(divobj);},update:function(text,ind){divobj=new Element('DIV',{'id':'jsslide_'+ind,'class':'jsslide'});divobj.innerHTML=text;divobj.setStyle('position','absolute');divobj.setStyle('z-index',1);divobj.setStyle('width',this.options.w);divobj.setStyle('height',this.options.h);divobj.inject(this.options.wrapper);this.hide(divobj);this.elements[ind]=divobj;},hide:function(el){if(this.options.mode=='vertical'){el.setStyle('top','-999em');el.setStyle('left','0');}else{el.setStyle('top','0');el.setStyle('left','-999em');}},setPos:function(elems){if(!elems)elems=this.getRunElems();var posT;var posL;var display;for(var i=0;i<elems.length;i++){var el=elems[i];if(el){if(this.options.mode=='vertical'){if(this.options.direction=='left'||this.options.direction=='up'){posT=this.options.h*i;}else{posT=this.options.h*(i-1);}
el.setStyle('top',posT);this.loadImage(el);}else{if(this.options.direction=='left'||this.options.direction=='up'){el.setStyle('left',this.options.w*i);}else{el.setStyle('left',this.options.w*(i-1));}
this.loadImage(el);}}}},loadImage:function(el){var holder=el.getElement(".ja-image");if(holder){var image=holder.getProperty('rel');if(image!=''&&image!=null){holder.setHTML(image);holder.setProperty('rel','')}}},getRunElems:function(){var objs=new Array();if(this.options.direction=='left'||this.options.direction=='up'){adj=0;}else{adj=this.elements.length-1;}
for(var i=0;i<=this.options.num_elem;i++){objs[i]=this.elements[(this.current+i+adj)%this.elements.length];}
if(this.options.total<=this.options.num_elem){if(this.options.direction=='left'||this.options.direction=='up'){objs[this.options.num_elem]=null;}else{objs[0]=null;}}
return objs;},start:function(){this.clearTimeOut();if(!this.elements[this.next()]){this.nextRun();return;}
if(this.elements[this.next()]=='fetching'){this.nextRun();return;}
if(this.running)return;this.running=1;var objs=this.getRunElems();this.setPos(objs);this.x=new Fx.Elements(objs,{duration:this.options.duration,onComplete:this.end.bind(this)});this.x.start(this.getFx());this.current=this.nextCurr();},end:function(){this.running=0;this.nextRun();},clearTimeOut:function(){if(this.timeOut){clearTimeout(this.timeOut);this.timeOut=0;}},nextRun:function(){this.clearTimeOut();if(this.options.total<=this.options.num_elem)return;if(this.options.auto){this.timeOut=setTimeout(this.start.bind(this),this.options.interval);this.fetchNext();}},nextCurr:function(){var next=0;if(this.options.direction=='left'||this.options.direction=='up'){next=(this.current+1)%this.elements.length;}else{next=(this.current+this.elements.length-1)%this.elements.length;}
return next;},next:function(){var next=0;if(this.options.direction=='left'||this.options.direction=='up'){next=(this.current+this.options.num_elem)%this.elements.length;}else{next=(this.current+this.elements.length-1)%this.elements.length;}
return next;},fetchNext:function(){var next=this.next();if(!this.elements[next]){this.elements[next]='fetching';url=this.options.url+'?total='+this.options.total+'&news='+next+'&loadajax=1&modid='+this.options.modid;new Request(url,{method:'get',onComplete:function(request){this.update(request,next)}.bind(this)}).send();return;}},fetchUpdate:function(text,next){this.update(text,next);},setDirection:function(direction){this.options.direction=direction;}});;;

/* js_371276d1a2117ddc7bc347f0ea2d1b11.script.js */
var JASliderCSS=new Class({Implements:Options,options:{interval:5000,duration:2000,repeat:true,autoplay:true,navigation:false,thumbnail:false,urls:null,targets:null},initialize:function(element,options){var jslider=$(element);if(!jslider){return false;}
this.setOptions(options);var options=this.options,jmain=jslider.getElement('.ja-ss-items'),jitems=jslider.getElements('.ja-ss-item'),vars={jslider:jslider,jmain:jmain,jitems:jitems,total:jitems.length,curIdx:-1,nextIdx:-1,curImg:null,retain:0,touch:'ontouchstart'in window&&!(/hp-tablet/gi).test(navigator.appVersion),running:0,stop:0,timer:0,animFinished:this.animFinished.bind(this)};jitems[0].clone().setStyles({'position':'relative','visibility':'hidden','z-index':1}).addClass('ja-ss-item-ghost').inject(jmain,'top');jitems.each(function(item){item._className=item.className;});this.vars=vars;this.initItemAction();this.initThumbAction();this.initControlAction();this.initKbNav();if(vars.touch){this.initTouchDevice();}
vars.direct='next';jslider.setStyle('visibility','visible');this.prepare(vars.curIdx+1);this.animFinished();},stop:function(){clearTimeout(this.vars.timer);this.vars.stop=1;},prev:function(){var vars=this.vars;if(vars.running){return false;}
this.prepare(vars.curIdx-1);},next:function(){var vars=this.vars;if(vars.running){return false;}
this.prepare(vars.curIdx+1);},playback:function(){this.vars.direct='prev';this.vars.stop=0;this.prev();},play:function(){this.vars.direct='next';this.vars.stop=0;this.next();},start:function(){var vars=this.vars;clearTimeout(vars.timer);vars.timer=setTimeout(this[this.vars.direct].bind(this),this.options.interval)},load:function(idx){var vars=this.vars;vars.jitems[idx].store('loaded',1);vars.retain=Math.max(0,vars.retain-1);if(vars.nextIdx==idx){this.run(idx);}else if(vars.nextIdx==-1){if(vars.retain==0){vars.jslider.removeClass('ja-ss-loading');}}},prepare:function(idx){var vars=this.vars,options=this.options;if(idx>=vars.total){idx=0;}
if(idx<0){idx=vars.total-1;}
var curImg=vars.jitems[idx];if(curImg.get('tag')!='img'){curImg=curImg.getElement('img');}
if(!curImg){return this.run(idx);}
vars.nextIdx=idx;if(curImg.retrieve('loaded')){return this.run(idx);}else{vars.running=true;vars.retain++;vars.jslider.addClass('ja-ss-loading');Asset.image(curImg.src,{'onLoad':this.load.bind(this,idx)});}},run:function(idx){var vars=this.vars,options=this.options;vars.retain=0;vars.jslider.removeClass('ja-ss-loading');if(vars.curIdx==idx){return false;}
vars.running=true;this.slide(idx);if(vars.jthumbitems){vars.jthumbitems.removeClass('active')[idx].addClass('active');}
vars.jslider.removeClass('ja-ss-progress');},slide:function(idx){var options=this.options,vars=this.vars;vars.jitems.each(function(item,index){var cls=(idx==index)?'curr active':(index<idx&&(index!=0||idx!=vars.jitems.length-1))?'prev':(index>idx&&(idx!=0||index!=vars.jitems.length-1))?'next':(idx==0)?'prev':'next';if(item.hasClass('curr')||cls.match(/curr/))cls='animate '+cls;item.className=item._className+' '+cls;});clearTimeout(vars.timer);vars.timer=setTimeout(vars.animFinished,this.options.duration);vars.curIdx=idx;},animFinished:function(){var options=this.options,vars=this.vars;vars.running=false;if(!vars.stop&&(options.autoplay&&(vars.curIdx<vars.total-1||options.repeat))){this.start();vars.jslider.addClass('ja-ss-progress');}},initThumbAction:function(){var options=this.options;if(options.thumbnail){var vars=this.vars,jslider=vars.jslider,jthumbs=vars.jslider.getElement('.ja-ss-thumbs'),jthumbitems=vars.jslider.getElements('.ja-ss-thumb');if(jthumbitems.length){jthumbitems.removeClass('active');for(var i=0,il=jthumbitems.length;i<il;i++){jthumbitems[i].addEvent('click',this.prepare.bind(this,[i]));}
jthumbs.addEvent('mousewheel',function(e){if(e.wheel<0){e.stop();this.next(true);}else{e.stop();this.prev(true);}}.bind(this));Object.append(vars,{jthumbitems:jthumbitems});}}},initControlAction:function(){var btnarr,options=this.options;if(options.navigation){var jslider=this.vars.jslider,controls=['prev','play','stop','playback','next'];for(var j=0,jl=controls.length;j<jl;j++){if(this[controls[j]]){btnarr=jslider.getElements('.ja-ss-'+controls[j]);for(var i=0,il=btnarr.length;i<il;i++){btnarr[i].addEvent('click',this[controls[j]].bind(this,true));}}}}},initItemAction:function(){var options=this.options;if(options.urls){var vars=this.vars,handle=function(e){var index=vars.jitems.indexOf(this);if(index==-1){index=vars.curIdx;}
var url=options.urls[index],target=options.targets[index];if(e.target.get('tag').toLowerCase()=='a'){return true;}
if(url){e.stop();if(target=='_blank'){window.open(url,'JAWindow');}else{window.location.href=url;}}
return false;};vars.jmain.addEvent('click',handle);vars.jitems.addEvent('click',handle);}},initTouchDevice:function(){var inst=this,vars=this.vars,ltouch=function(){vars.ltouch=true;console.log(1);},start=function(e){clearTimeout(vars.ltid);var point=e.touches[0];vars.moved=false;vars.px=point.pageX;vars.tm=e.timeStamp||new Date().getTime();vars.ltouch=false;vars.ltid=setTimeout(ltouch,300);document.addEvent('touchmove',move);vars.jslider.addEvent('touchend',end);},move=function(e){clearTimeout(vars.ltid);if(!vars.ltouch){e.stop();}
var tm=e.timeStamp||new Date().getTime();if(tm-vars.tm>300){vars.tm=tm;vars.px=e.touches[0].pageX;}
vars.moved=true;},end=function(e){if(e.touches.length!=0){return;}
document.removeEvent('touchmove',move);vars.jslider.removeEvent('touchend',end);var point=e.changedTouches[0];if(!vars.moved){var target=point.target;while(target.nodeType!=1){target=target.parentNode;}
if(target.tagName!='SELECT'&&target.tagName!='INPUT'&&target.tagName!='TEXTAREA'){var ev=document.createEvent('MouseEvents');ev.initMouseEvent('click',true,true,e.view,1,point.screenX,point.screenY,point.clientX,point.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,0,null);ev._fake=true;target.dispatchEvent(ev);}}else if(((e.timeStamp||new Date().getTime())-vars.tm)<300){if(point.pageX-vars.px>30){inst.prev(true);}else if(point.pageX-vars.px<-30){inst.next(true);}}};vars.jslider.addEvent('touchstart',start);},initKbNav:function(){document.addEvent('keydown',function(e){if(e.code==39||e.code==40){this.next();}else if(e.code==37||e.code==38){this.prev();}}.bind(this));}});;;

